// Nom du snack : eni_react_native_villes_ajout
// Nom du script : App.js
// Auteur : Christian VIGOUROUX
// Date de création : 11/07/2024
// Date de dernière modification : 11/07/2024 (Christian VIGOUROUX)
// Objet : Ajout d'une ville dans la table MySQL villes
// URL : https://snack.expo.dev/@cvigouroux/eni_reac_native_villes_ajout

// Import des composants React Native et React
import React, { useState } from 'react';
import {
  SafeAreaView,
  StyleSheet,
  View,
  Text,
  TextInput,
  Button,
  Alert
} from 'react-native';

// Fonction principale App
export default function App() {

  // Constantes de la fonction App
  const [nomVille, setNomVille] = useState('');

  // Fonction de gestion de la soumission du formulaire
  const handleSubmit = () => {
    
    // Test sur le nom de la ville
    if (!nomVille) {
      Alert.alert('Erreur', 'Veuillez saisir le nom de la ville');
      return;
    }

    // Insertion dans la table MySQL villes
    fetch('http://christian-vigouroux.fr/react/php_mysql_insertion_ville.php', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ nomVille }),
    })
      .then((response) => {
        console.log('Response status:', response.status);
        return response.json();
      })
      .then((responseJson) => {
        console.log('Response JSON:', responseJson);
        if (responseJson.success) {
          Alert.alert('Succès', 'Ville ajoutée avec succès');
          setNomVille('');
        } else {
          Alert.alert('Erreur', 'Une erreur est survenue lors de l\'ajout de la ville : ' + responseJson.message);
        }
      })
      .catch((error) => {
        Alert.alert('Erreur', 'Une erreur est survenue lors de l\'ajout de la ville');
        console.error('Error:', error);
      });
  };

  // Valeur de retour de la fonction App
  return (

    // Vue principale SafeAreaView
    <SafeAreaView style={styles.container}>
      
      {/* Composant View */}
      <View style={styles.form}>

         {/* Zone de texte explicative */}
        <Text style={styles.label}>Nom de la ville :</Text>
        
         {/* Zone de saisie */}
        <TextInput
          style={styles.input}
          value={nomVille}
          onChangeText={setNomVille}
          placeholder="Saisissez le nom de la ville"
        />
        
        {/* Bouton de validation */}
        <Button title="Ajout de la ville" onPress={handleSubmit} />
      
      </View>
    
    </SafeAreaView>

  );

}

// Styles CSS
const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#f5f5f5',
  },
  form: {
    width: '80%',
  },
  label: {
    fontSize: 18,
    marginBottom: 10,
  },
  input: {
    height: 40,
    borderColor: 'gray',
    borderWidth: 1,
    marginBottom: 20,
    paddingLeft: 10,
    backgroundColor: 'white',
  },
});